<?php
  // start a php session so we can store session language between F5 hits
  session_start();
  // get the configuration from ldappw.ini
  $config = parse_ini_file("./config/ldappw.ini",true);
  $pwRule = $config["base"]["pwrule"];
  $dfLang = $config["lang"][$config["base"]["dflang"]];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
  <title>Change Password</title>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
  <meta name="keywords" content="ldap change password" />
  <link rel="stylesheet" href="ldappw.css" type="text/css" media="screen" />
  <script src="./js/cookies.js" type="text/javascript"></script>
  <script src="./js/md5.js" type="text/javascript"></script>
  <script src="./js/url.js" type="text/javascript"></script>
  <script src="./js/ldappw.js" type="text/javascript"></script>
</head>

<script language="JavaScript">
<!--
  dfLang = "<?php echo $dfLang ?>";
  pwRule = "<?php echo $pwRule ?>";
//-->
</script> 
<body onload='document.forms["fPWC"].sUserName.focus();'>
<div class="working_gif" name="working" id="working"><img src="./img/contacting.gif" /></div>
<div id="frm_container">
  <table class="ldheader" cellspacing="0">
    <tr>
    	<td class="alt"><img src="./img/logo.png" /></td>
    	<td class="arb"><label id=hCapt name=hCapt></label></td>
    </tr>
  </table>
  <div class="pwd_form">
  <form name="fPWC" id="fPWC" method="POST" onSubmit="return false" onload="sUsername.focus();">
    <p>
      <label id=uName name=uName></label>
      <input name="sUserName" id="sUserName" type="text" class="input_text" size="40" maxlength="12" tabindex="1"
       value="" onchange="hideStatus();" />
    </p>
    <p>
      <label id=cPass name=cPass></label>
      <input name="sCPWD" id="sCPWD" type="password" class="input_text" size="12" maxlength="16" tabindex="2"
       value="" onfocus="this.select();" onchange="hideStatus();" />
    </p>
    <p>
      <label id=nPass name=nPass></label>
      <input name="sNPWD" id="sNPWD" type="password" class="input_text" size="12" maxlength="18" tabindex="3"
       value="" onfocus="this.select();" onchange="hideStatus();" />
    </p>
    <p>
      <label id=vPass name=vPass></label>
      <input name="sConfirm" id="sConfirm" type="password" class="input_text" size="12" maxlength="18" tabindex="4"
       onfocus="this.select();" value="" onchange="hideStatus();" />
    </p>
    <center>
      <input class="img_button" name="bSubmit" id="bSubmit" type="submit" value="Submit" tabindex="5"
             onclick="hideStatus(); return CheckForm(fPWC);" /> 
    </center>
  </form>
  </div>
  <table>
    <tr>
      <td>
        <img class="img_mesg" name "msgicon" id="msgicon" src="./img/none.png" />
      </td><td>
        <textarea class="area_mesg" name="messages" id="messages" onfocus='document.forms["fPWC"].sUserName.focus();'></textarea>
      </td>
    </tr>
  </table>
  <form name="params" id="params" action="ldappw.php" method="post" />
    <input name="sUser" id="sUser" type="hidden" value="" />
    <input name="sCPWD" id="sCPWD" type="hidden" value="" />
    <input name="smd5"  id="smd5"  type="hidden" value="" />
    <input name="sLang" id="sLang" type="hidden" value="" />
  </form>
</div>
  <div id="lang">
    <table width=100%>
      <tr><td>
        <label id=uLang name=uLang></label>
        <select name="mLang" id="mLang" onchange="xmlLoadLang(this.value)">
        <?php
          // get session language if defined, else use dflang from ldappw.ini
          if (isset($_SESSION['mLang']))
            $currentLang = $_SESSION['mLang'];
          else if (isset($_COOKIE["mLangLdap"]))
            $currentLang = $_COOKIE["mLangLdap"];
          else $currentLang = $dfLang;

          // populate the drop-down box
          foreach ($config["lang"] as $Language=>$Code) {
            $sSel = sprintf('%s', ($currentLang == $Code )?' selected':'');
            printf('<option value="%s"%s>%s</option>', $Code, $sSel, $Language);
          }
        ?>
        </select>
      </td><td align="right">
        Version 0.2
      </td></tr>
    </table>
  </div>
</body>
<script language="JavaScript">
  loadLang(dfLang);
</script>
</html>
