<?php
//
//  Debug? Call this page directly!
//
$_DEBUG = 0;

//
//  Load configuration
//
$config = parse_ini_file("./config/ldappw.ini");

//
//  Get form posted variables
//
$User = $_POST['sUser'];
$CPWD = $_POST['sCPWD'];
$PWD  = $_POST['smd5'];
$mLang= $_POST['sLang'];

$sMessage = "";
$iResult  = 0;
$Today	  = floor(time()/86400);
$message  = parse_ini_file("./lang/$mLang.msg",true);

if ($_DEBUG) {
  echo('<script>alert("User\t\t: '.$User.'\n'.
                      'CPWD\t: '.$CPWD.'\n'.
                      'PWD\t\t: '.$PWD.'");</script><br />');
}

//
// Connect to LDAP Server, do an anonymous bind to check connection:
//   Returns a positive LDAP link identifier on success, or FALSE on error.
//   When OpenLDAP 2.x.x is used, ldap_connect() will always return a resource as
//   it does not actually connect but just initializes the connecting parameters.
//   The actual connect happens with the next calls to ldap_* funcs, usually with ldap_bind(). 
//
  $ldapServer = @ldap_connect($config["server"]);
  @ldap_set_option($ldapServer, LDAP_OPT_PROTOCOL_VERSION, 3);
  
  if (!@ldap_bind($ldapServer) ) {
    $sMessage = $message["php"]["P0000"]."\n".$config["server"];
    $iResult=5;
    echo urlencode('rid='.$iResult.'|sMessge='.$sMessage);
    exit;
  }

if ($_DEBUG) {
  var_dump($ldapServer);
  echo '<br />';
  if ($ldapServer) {
    echo $message["php"]["P0001"].' '.$config["server"].'<br />';
  } else {
    echo $message["php"]["P0000"].' '.$config["server"].'<br />';
  }
}

//
//  Lookup user we're supposed to be changing
//
  $ldapSearch  = ldap_search($ldapServer, $config["basedn"], "uid=".$User);
  $ldapEntries = ldap_get_entries($ldapServer, $ldapSearch);

  $dn           = $ldapEntries[0]["dn"];
  $sdexpire     = $ldapEntries[0]["shadowexpire"][0];
  $sdshadowmin  = $ldapEntries[0]["shadowmin"][0];
  $sdshadowmax  = $ldapEntries[0]["shadowmax"][0];
  $sdnextchange = $ldapEntries[0]["shadowlastchange"][0] + $sdshadowmin;
  $sdlastchange = $ldapEntries[0]["shadowlastchange"][0] + $sdshadowmax + $ldapEntries[0]["shadowinactive"][0];

if ($_DEBUG) {
  var_dump($ldapEntries);	// View page source to read this ;)
  echo "<hr />";
  echo('<script>alert("sExp\t: '.$sdexpire.'\n'.
                      'sMin\t: '.$sdshadowmin.'\n'.
                      'sMax\t: '.$sdshadowmax.'\n'.
                      'sNxt\t: '.$sdnextchange.'\n'.
                      'pExp\t: '.$sdlastchange.'");</script>');
}

//
// Bind / login to LDAP server with users dn
//
  if ( !$iResult ) {
    $ldapBind = @ldap_bind($ldapServer, $dn, $CPWD);
    if (!$ldapBind) {
      $sMessage=$message["php"]["P0002"];
      $iResult = 1;
    } else {
//
//  Check that last password change wasn't too recent
//
      if ($sdnextchange > $Today) {
        $sMessage=$message["php"]["P0003"];
        $iResult=2;
      } else {
//
//  Check that account and password haven't expired
//
        if ($sdexpire < $Today) {
          $sMessage=$message["php"]["P0004"];
          $iResult=3;
        }
        if ($sdshadowmax != -1 && $sdlastchange < $Today) {
          $sMessage=(strlen($sMessage))?$message["php"]["P0005"]:$message["php"]["P0006"];
          $iResult=4;
        }
        if ($iResult) $sMessage.="\n".$message["php"]["P0007"];
        else {
          $Updates = array('userPassword'     => '{md5}'.base64_encode(pack('H*', $PWD)), 
                           'shadowLastChange' => $Today);
          if (ldap_modify($ldapServer, $dn, $Updates)) {
            $sMessage=$message["php"]["P0008"];
            $iResult=0;
          }
          else {
            $sMessage="Aww crap";
            $iResult=5;
          }
        }
        ldap_unbind($ldapServer);
      }
    }
  }
  echo urlencode('rid='.$iResult.'|sMessge='.$sMessage);
?>
